Scriptname _SLSubmitShoutEffect extends ActiveMagicEffect  

_SLSubmitConfig Property _SLConfig auto
_SLSubmitFunctions Property _SLFunctions auto
_SLSubmitQuest Property _SLQuest auto
_SLSubmitScene Property _SLScene auto
PlayerVampireQuestScript Property PVQ Auto
Keyword Property ActorTypeNPC  Auto  

GlobalVariable Property SuccessChance  Auto  
GlobalVariable Property SuccessRoll  Auto  
Float Property FailurePenalty  Auto 
GlobalVariable Property _SLSubmitFailurePenalty  Auto  
Idle Property _SLSubmitSmack  Auto  
float Property THealth  Auto
Topic Property _SLSubmitBleedOut Auto
Weapon Property TargetWeapon1  Auto  
Weapon Property TargetWeapon2  Auto  
Spell Property _SLSubmitUnarmed Auto
Spell Property _SLSubmitCalm Auto
MagicEffect Property CalmEffect Auto
Keyword Property Vampire Auto
ReferenceAlias Property ActorVictim  Auto  
Faction Property _SLSubmitFaction Auto
Faction Property _SLSubmitRecoverFaction Auto
Faction Property _SLSubmitBountyFaction Auto
Spell Property Slap Auto
Actor Property PlayerRef Auto

Event OnEffectStart(actor Target, actor Caster)
	If (Target.HasKeyword(ActorTypeNPC) && (Target.IsInCombat() || Target.HasMagicEffect(CalmEffect)))
; // Code for the success algorithm
		Target.GetLeveledActorBase().SetProtected()
		THealth = Target.GetAV("Health")/Target.GetBaseAV("Health")*100
		_SLQuest.GatherStats(Target,Caster)
		_SLQuest.ShoutChance()
; // Code for what happens on success
		If (THealth <= 90.0)
			If (SuccessChance.GetValue() >= SuccessRoll.GetValue())
				If (!Target.IsInFaction(_SLSubmitRecoverFaction))
					Target.AddToFaction(_SLSubmitRecoverFaction)
				EndIf
				If (_SLSubmitFailurePenalty.GetValue() > 0.0)
					FailurePenalty = _SLSubmitFailurePenalty.GetValue() - 10
					_SLSubmitFailurePenalty.SetValue(FailurePenalty)
				EndIf
				If(_SLConfig.debugActive)
					Debug.Notification(SuccessChance.GetValue() + "% success chance, " + SuccessRoll.GetValue() + "% rolled.  Target submits!")
				EndIf
				ActorVictim.ForceRefTo(Target)
				If (!Target.IsInFaction(_SLSubmitFaction))
					Target.AddToFaction(_SLSubmitFaction)
				EndIf
				_SLSubmitCalm.Cast(Target)
				;_SLScene.WRT(1.0)
				Debug.SendAnimationEvent(Target, "BleedOutStart")
				_SLScene.WRT(0.1)
				Game.EnablePlayerControls()
				Target.Say(_SLSubmitBleedOut)
				_SLSubmitCalm.Cast(Target)
				Target.StopCombat()
				_SLScene.WRT(5.0)
				If(PlayerRef.IsTrespassing())
					Target.SetRelationshipRank(PlayerRef,1)
				EndIf
				Caster.PushActorAway(Target, 0)
				_SLScene.WRT(5.0)
				If (Target.IsInFaction(_SLSubmitRecoverFaction))
					Target.RemoveFromFaction(_SLSubmitRecoverFaction)
				EndIf
				If (!Target.IsInFaction(_SLSubmitBountyFaction) && _SLQuest.IsHostileNPC(Target))
					Target.AddToFaction(_SLSubmitBountyFaction)
				EndIf
			Else
; // Code for what happens on failure
				If (_SLSubmitFailurePenalty.GetValue() < 50.0)
					FailurePenalty = _SLSubmitFailurePenalty.GetValue() + 10
					_SLSubmitFailurePenalty.SetValue(FailurePenalty)
				EndIf
				If(_SLConfig.debugActive)
					Debug.Notification(SuccessChance.GetValue() + "% success chance, " + SuccessRoll.GetValue() + "% rolled.  Target resists!")
				EndIf
			EndIf
		Else
			If (_SLSubmitFailurePenalty.GetValue() < 50.0)
				FailurePenalty = _SLSubmitFailurePenalty.GetValue() + 10
				_SLSubmitFailurePenalty.SetValue(FailurePenalty)
			EndIf
			If(_SLConfig.debugActive)
				Debug.Notification("Target's health is " + THealth + "% and is over 90%.  Target automatically resists!")
			EndIf
		EndIf
	Else
		If (_SLSubmitFailurePenalty.GetValue() < 50.0)
			FailurePenalty = _SLSubmitFailurePenalty.GetValue() + 10
			_SLSubmitFailurePenalty.SetValue(FailurePenalty)
		EndIf
		If(_SLConfig.debugActive)
			Debug.Notification("Target is an invalid target.  Target automatically resists!")
		EndIf
	EndIf
EndEvent
